/*
 * Created on Aug 20, 2003
 */
package Data;

import java.sql.*;

/**
 * @author student
 * This class is being used for getting and setting message data
 * 
 */
public class MessageData {
	String from;
	String to;
	String body;
	String subject;
	Timestamp time;

	/**
	 * Constructor for MessageData.java
	 */
	public MessageData() {
	}

	/**
	 * Constructor for MessageData.java with parameters
	 */
	public MessageData(
		String from,
		String to,
		String body,
		String subject,
		Timestamp time) {
		this.from = from;
		this.to = to;
		this.body = body;
		this.subject = subject;
		this.time = time;
	}

	/**
	 * This method is being used to get the firstname and the lastname of the 
	 * person who posted the message
	 * @return String The person who posted the message.
	 * @param void
	 */
	public String getFrom() {
		return from;
	}
	/**
	 * This method is being used to set the name of the 
	 * person who posted the message
	 * @param String The person who posted the message.
	 * @return void.
	 */
	public void setFrom(String from) {
		this.from = from;
	}
	/**
	 * This method is being used to get the name of the 
	 * person who  the message is posted to
	 * @param void
	 * @return String The person who the message is posted to .
	 */
	public String getTo() {
		return to;
	}
	/**
	 * This method is being used to set the name of the
	 * person the message was posted to.
	 * @return void.
	 * @param String The person who the message is posted to
	 */
	public void setTo(String to) {
		this.to = to;
	}

	/**
	 * This method is being used to get the body of the message
	 * @param void
	 * @return String Body of the message.
	 */
	public String getBody() {
		return body;
	}
	/**
	 * This method is being used to set the body of the message.
	 * @return void.
	 * @param String Body of the message .
	 */
	public void setBody(String body) {
		this.body = body;
	}
	/**
	 * This method is being used to get the subject of the message
	 * @param void
	 * @return String Subject of the message.
	 */
	public String getSubject() {
		return subject;
	}
	/**
	 * This method is being used to set the subject of the message.
	 * @return void.
	 * @param String Subject of the message.
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}
		/**
	 * This method is being used to get the time the message was posted.
	 * @param void
	 * @return time Time the message was posted.
	 */
	public Timestamp getTime() {
		return time;
	}
	/**
	 * This method is being used to set the time  the message was posted.
	 * @return void.
	 * @param time Time the message was posted .
	 */
	public void setTime(Timestamp time) {
		this.time = time;
	}
}
